Attribute VB_Name = "Modulo1"
Option Explicit

Public gFontName As String


Public IniPathParGen As String
Public IniLocalPath As String
Public gTipoDB As Byte ' 0=SQL; 1=ACCESS

'Public gChiusuraForzata As Boolean
Public gPostazioneINVIO As Boolean
Public gAppInERRORE As Boolean

Public gAzienda As String



Public ConnDBPrimo As ADODB.Connection   'punta all'mdb GENERALE che si trova sotto la directory "[App.path]&\DB\Generale.mdb"
Public gConnPRIMOOpened As Boolean 'Mi indica se la connessione col Database di PRIMO  ATTIVA



Public gSmsUSER As String
Public gSmsPSSW As String
Public gSmsMITT As String

'Variabili per l'invio degli SMS (soprattutto Promemoria)
'Public gSmsAbilitati As Byte     '1=Abilitati
Public gSmsTxtPromem As String   'Testo per gli SMS Promemoria
Public gSmsOrePreavv As Byte     'Ore di Preavviso per inviare l'SMS Promemoria
Public gSmsPrefInter As String   'Prefisso Internazionale
Public gSmsLenAlias As Byte      'Lunghezza Max Campo Alias

Public gOrderIDSMS As Long

Public gErrorInSubMain As String



'***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
Public gSmsPostVendita As Byte     'Flag che abilita la gestione degli SMS Post-Vendita
Public gSmsOrePosticipate As Byte  'Ore successive di invio SMS Post-Vendita
Public gSmsOreMaxPostVendita As Byte  'Ore MAX in cui tentare l'invio SMS Post-Vendita
'***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO


'****  DICHIARAZIONI PER I Form SEMPRE IN PRIMO PIANO   ****
Private Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, _
                                                    ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, _
                                                    ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Const SWP_NOSIZE = &H1
Const SWP_NOMOVE = &H2
Const SWP_SHOWWINDOW = &H40
Const HWND_NOTOPMOST = -2
Const HWND_TOPMOST = -1


Declare Function TerminateProcess Lib "kernel32" (ByVal hProcess As Long, ByVal uExitCode As Long) As Long

'Per leggere nel file INI
Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpDefault As String, _
                   ByVal lpReturnedString As String, _
                   ByVal nSize As Long, _
                   ByVal lpFileName As String) _
                  As Long

Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpString As Any, _
                   ByVal lpFileName As String) _
                  As Long


Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, _
ByVal wMsg As Long, ByVal WParam As Long, lParam As Any) As Long


Public Declare Function ReleaseCapture Lib "user32" () As Long
Public Const WM_NCLBUTTONDOWN = &HA1
Public Const HTCAPTION = 2
Public Const EM_GETLINECOUNT = &HBA


Public Declare Sub Sleep Lib "kernel32.dll" (ByVal dwMilliseconds As Long)


Public Site As String
'Costante x la conversione del Path DOS
Public Const SW_SHOWNORMAL As Long = 1

'Per aprire i file in automatico
Declare Function ShellExecute Lib "shell32.dll" _
Alias "ShellExecuteA" _
(ByVal hWnd As Long, ByVal lpOperation As String, _
ByVal lpFile As String, ByVal lpParameters As String, _
ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public Const CB_SHOWDROPDOWN = &H14F '(per aprire e chiudere la combo in automatico)

Dim gMaxTimeout As Long

Sub Main()
   Dim vParGenPrimoOK As Boolean
   ''Evito che si eseguano pi Sessioni di lavoro
   'If App.PrevInstance = True Then
   '   End
   'End If
   
   'Setto le variabili CSS
      Call SetCSSApp
   
   
   'Path del ParSmsTools.CNF di SmsTools
      IniLocalPath = App.Path + "\ParSmsTools.CNF"
      'Imposto i valori di default nel File Ini Locale
         Call WriteINI("AZIONE", "CLOSE", "F", IniLocalPath)
         'Call WriteINI("AZIONE", "PAUSE", "F", IniLocalPath)
   
   
   'QUI verifico se gli  stato passato da PRIMO il path del ParGen.cnf su cui deve lavorare
      Dim vUserPath As String
      vUserPath = Command()
'vUserPath = "C:\Users\g.novi\PRIMO TEST\"
      vUserPath = Trim(vUserPath)
      If Len(Trim(vUserPath)) > 0 Then
         If Right(vUserPath, 1) = "\" Then
            vUserPath = Mid(vUserPath, 1, Len(vUserPath) - 1)
         End If
         vParGenPrimoOK = VerificaEsistenzaFile(vUserPath & "\ParGen.cnf")
         If vParGenPrimoOK Then IniPathParGen = vUserPath & "\ParGen.cnf"
      End If
   
   
   'Qui verifico se devo cercare ancora il Path del ParGen.cnf
      If Not vParGenPrimoOK Then
      '-> PRIMA CONTROLLO SE C' IL PARAMETRO NEL ParSmsTools.CNF _
          POI CONTROLLO SE C' IL PARGEN.CNF NELL'APP.PATH _
          ED IN ULTIMA ANALISI PRENDO QUELLO IN App.Path & "\..\..\
            
         'Prendo (eventualmente sia stato specificato da PRIMO) il Path del ParGen.CNF _
          (questo si  reso indispensabile dalla parametrizzazione in PRIMO del percorso del ParGen.CNF)
            IniPathParGen = ReadINI("PARAMETRI", "PATH_PARGEN", IniLocalPath)
                     
         'Questo PARAMETRO comanda su tutte le altre configurazioni
            If Len(Trim(IniPathParGen)) = 0 Then
               'Controllo se c' un ParGen.CNF nel App.Path e nel qual caso comanda
               If VerificaEsistenzaFile(App.Path & "\ParGen.cnf") Then
                  IniPathParGen = App.Path & "\ParGen.cnf"
               Else
                  IniPathParGen = App.Path & "\..\..\ParGen.cnf"
               End If
            End If
      End If
      
      
   'Se arriva qui controllo che il ParGen esista. In caso contrario ESCO
      If VerificaEsistenzaFile(IniPathParGen) = False Then
         Call MsgInLogFile("ERRORE!!! -> Sub 'MAIN' - File di configurazione non trovato! (" & IniPathParGen & ")", True)
         
         gErrorInSubMain = "SmsTOOLS - Application ALERT!" & vbNewLine & vbNewLine & _
                           "File di configurazione non trovato!" & vbNewLine & _
                           "(" & IniPathParGen & ")" & vbNewLine & vbNewLine & _
                           "(Si consiglia di contattare l'Assistenza il prima possibile!)"
         'End
      End If
      
      
      Dim vTO As String
      vTO = ReadINI("PARAMETRI", "TIMEOUT", IniLocalPath)
      If Not IsNumeric(vTO) Then
         gMaxTimeout = 120
         Call WriteINI("PARAMETRI", "TIMEOUT", "120", IniLocalPath)
      Else
         gMaxTimeout = CLng(vTO)
      End If
      
      
   'Avvio la Form nascosta
   Form1.Hide
   'Form1.Show
End Sub

'Funzione per leggere nel file INI
Public Function ReadINI(ByVal AppName As String, KeyName As String, Filename As String) As String
Dim INIreturn As String
        
    INIreturn = String(255, Chr(0))
    ReadINI = Left(INIreturn, GetPrivateProfileString(AppName, KeyName, "", INIreturn, _
        Len(INIreturn), Filename))
End Function
'Funzione per scrivere nel file INI
Public Sub WriteINI(ByVal AppName As String, KeyName As String, NewString As String, Filename As String)
Dim Flag As Integer
        
    Flag = WritePrivateProfileString(AppName, KeyName, NewString, Filename)
End Sub


'Public Function GetHandlePRIMO() As String
'
'   GetHandlePRIMO = ReadINI("PARAMETRI", "HANDLE", IniPathParGen)  'Per PrimoBackup
'
'End Function


Public Function NonNullo(Argomento As Variant, Optional Numerico As Boolean) As Variant
   If IsNull(Argomento) Then
      If Numerico = False Then
         NonNullo = ""
      Else
         NonNullo = "0"
      End If
   Else
      If Numerico = False Then
         NonNullo = Argomento
      Else
         If IsNumeric(Argomento) = True Then 'Qui faccio un ulteriore controllo se il valore deve essere numerico
            NonNullo = Argomento
         Else
            NonNullo = "0"
         End If
      End If
   End If
End Function

Public Sub MsgInLogFile(Msg As String, Optional pError As Boolean)
   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRec As String
   Dim vNomeFile As String

   On Error Resume Next

   If pError = True Then
      vNomeFile = "ErrorLog_" & Format(Date, "yyyy.mm") & ".cnf"
   Else
      vNomeFile = "EventLog_" & Format(Date, "yyyy.mm") & ".cnf"
   End If


   Call VerificaEsistenzaPathCartella(App.Path & "\Log")


   'If pNuovoFile = True Then
   '   Call RinominaFile(App.Path & "\Log\", vNomeFile)
   'End If


   NumFile = FreeFile

   'Apro il file LOG
   Open App.Path & "\Log\" & vNomeFile For Append As #NumFile     'CREO IL FILE

      'Stampo il messaggio (la riga!)
      vStrRec = Format(Date, "yyyy/mm/dd") & "|" & _
                Format(Now, "hh:nn:ss") & "|"

      vStrRec = vStrRec & "|" & Replace(Msg, Chr(13) + Chr(10), "")
      vStrRec = vStrRec & "|"

      Print #NumFile, vStrRec
      '+{榦ӱ=53?+jV+uY}4A65?AGT6A ???

      'STRUTTURA STRINGA : _
      DATA SISTEMA | ORA SISTEMA | STRINGA | CARATTERE DI FINE RIGA ()

   'Chiudo il file di LOG
   Close #NumFile

   'Questa istuzione mi serve per azzerare eventuali errori che possono verificarsi. In particolarte quando il comando _
    arriva da una form Modale l'istruzione MDIForm1.ActiveForm.Name genera l'errore 91
   On Error GoTo 0

End Sub


'*****************************************************
' Scopo......: converte la data in formato mm/gg/aa hh:mm:ss
' Input......: data e ora
' Restituisce: la data nel formato SQL: 'mm/gg/aa hh:mm:ss'
'*****************************************************
'Public Function DataOraSQL(ByVal strData As String, StrOra As Boolean, Optional DataConOra As Boolean) As String
Public Function DataOraSQL(ByVal strData As String, Optional StrOra As Boolean, _
                           Optional OraDB As String, Optional DataConOra As Boolean) As String

   Dim DataEora As String
   Dim vOra As String
   Dim vDat As String

''ACCESS
   If gTipoDB = 0 Then
      If StrOra Then
         'DataEora = (Mid(StrData, 4, 2) & "/" & Left(StrData, 2) & "/" & Right(StrData, 2)) & " " & Str(Hour(Time)) & ":" & Trim(Str(Minute(Time))) & ":" & Trim(Str(Second(Time)))
         DataEora = Format(strData, "hh:mm")
         DataEora = Replace(strData, ".", ":")
      Else
         vDat = Format(strData, "mm/dd/yyyy")
         If DataConOra = True Then
            vOra = Format(strData, "hh:nn:ss")
         Else
            vOra = Format(OraDB, "hh:nn:ss")
         End If
         vOra = Replace(vOra, ".", ":")
         DataEora = vDat & " " & vOra
         'DataEora = Trim((Mid(StrData, 4, 2)) & "/" & Trim(Left(StrData, 2)) & "/" & Trim(Right(StrData, 2)))
      End If
   
      DataOraSQL = "#" & Trim(DataEora) & "#"

'SQL
   Else
   
      If StrOra Then
         DataEora = Format(strData, "HH:nn:ss")
         DataEora = Replace(strData, ".", ":")
      Else
         
         vDat = Format(strData, "yyyymmdd")
         vOra = OraDB
         
         If DataConOra = True Then
            vOra = Format(strData, "HH:nn:ss")
         Else
            vOra = Format(OraDB, "HH:nn:ss")
         End If
         
         vOra = Replace(vOra, ".", ":")
         
         'DataOraSQL = "CONVERT(DATETIME, '" & vDat & " " & vOra & "', 102)"
         DataEora = vDat & " " & vOra
         
      End If
      DataOraSQL = "'" & Trim(DataEora) & "'"

   End If
   
End Function


'*****************************************************
' Scopo......: converte una stringa in formato SQL,
'              tenendo conto di eventuali apici, in qual caso li raddoppia
'              secondo lo standard delle stringhe SQL.
' Input......: una stringa
' Restituisce: la stringa nel formato SQL con gli apici singoli
'*****************************************************
Public Function VerificaApici(ByVal stringa As Variant) As String

    If IsNull(stringa) Or IsEmpty(stringa) Or stringa = "" Then
        VerificaApici = ""
        Exit Function
    End If
    
   VerificaApici = Replace(stringa, "'", "''")
End Function


Public Sub PausaProgram(pSecondi As Integer, Optional MenoDiUnSecondo As Boolean, Optional pUltraRapido As Boolean)
   Dim vTempoPart As Date
   Dim I As Long
   
   vTempoPart = DateAdd("s", pSecondi, Time)
   
   Do Until Time > vTempoPart
      DoEvents
      I = I + 1
      
      If pUltraRapido = True Then If I = 75000 Then Exit Do
      If MenoDiUnSecondo = True Then If I = 150000 Then Exit Do
   Loop

End Sub



Public Function GetValoriPRIMO() As Boolean '(Optional pNewRicerca As Boolean)
   Dim vPathDB As String
   Dim vNomeServerSQL As String
   Dim vNomeDBSQL_GEN As String
   Dim vPassword_SA As String
   Dim vConnessioneTrusted As String
   
   
   On Error GoTo GestErr
   
   
   'TRUE = Deve Gestire l'invio degli SMS; FALSE = Serve solo per mostrare lo stato
      'gPostazioneINVIO = (ReadINI("TOOLS", "ABILITA", IniPathParGen) = "1")
      gAzienda = "START" ' ReadINI("AZIENDA", "CODICE_ULTIMA_USATA", IniPathParGen)
         '* * * * HO DECISO CHE DEVE LAVORARE SOLO SULLA START * * * *
   
   
   'Verifico che tipo di connessione devo aprire
      Dim vType As String
      vType = ReadINI("CONN_SQL", "TYPE", IniPathParGen)
      If Len(Trim(vType)) = 0 Then vType = "0"
      gTipoDB = CByte(vType)
   
      
   'Controllo impostazione Azienda
      If Len(Trim(gAzienda)) = 0 Then
         'gChiusuraForzata = True
         Call MsgInLogFile("ERRORE!!! -> Ultima Azienda usata non risulta pi negli archivi", True)
         'MsgBox "Ultima Azienda usata non impostata nel ParGen" & vbNewLine & vbNewLine & _
                "(Si consiglia di contattare l'Assistenza il prima possibile!)", vbCritical
                
         Call Form1.ShowAPP(True, "Ultima Azienda usata non risulta pi negli archivi" & vbNewLine & vbNewLine & _
                                  "(Si consiglia di contattare l'Assistenza il prima possibile!)")
         Exit Function
      End If
   
   
   'Controllo se la Connessione  gi attiva ed eventualmente la Chiudo
   If gConnPRIMOOpened Then
      Call ChiudiConnessioneDBPrimo
   End If
   
   
   If gTipoDB = 0 Then 'ACCESS
   
      vPathDB = ReadINI("CONN_SQL", "PATH_DB", IniPathParGen)
      'Call MsgInLogFile("   > Path Db: " & vPathDB)
      
      If Len(Trim(vPathDB)) = 0 Then
         'gChiusuraForzata = True
         Call MsgInLogFile("ERRORE!!! -> Percorso 'DB' non trovato", True)
         'MsgBox "Path DB non trovato" & vbNewLine & vbNewLine & _
                "(Si consiglia di contattare l'Assistenza il prima possibile!)", vbCritical
                
         Call Form1.ShowAPP(True, "Percorso 'DB' non trovato" & vbNewLine & vbNewLine & _
                                  "(Si consiglia di contattare l'Assistenza il prima possibile!)")
         Exit Function
      End If
         
      If ApriConnessioneACCESS(vPathDB) = False Then
         'gChiusuraForzata = True
         Exit Function
      End If

   Else                'SQL

      vNomeServerSQL = ReadINI("CONN_SQL", "NAME_SERVER", IniPathParGen)
      vNomeDBSQL_GEN = ReadINI("CONN_SQL", "NAME_DB_GEN", IniPathParGen)
      vPassword_SA = ReadINI("CONN_SQL", "PASSWORD_SA", IniPathParGen)
      vConnessioneTrusted = ReadINI("CONN_SQL", "TRUSTED", IniPathParGen)

      If ApriConnessioneSQL(Trim(vNomeServerSQL), _
                            Trim(vNomeDBSQL_GEN), _
                            Trim(vPassword_SA), _
                            vConnessioneTrusted) = False Then
         'gChiusuraForzata = True
         Exit Function
      End If

   End If
   

   'QUI PRELEVO IL VALORE IP DAL DB NEI DATIAZIENDA ED IMPOSTO LA STRINGA DI CONNESSIONE _
    ACCERTANDOMI CHE NON SIA VUOTA
   If GetParamSMS = False Then
      'gChiusuraForzata = True
      Exit Function
   End If
   
   
   'QUI CREO LE QUERY NECESSARIE TENENDO CONTO DEL TIPO DI DB
   If SetQueryDB = False Then
      'gChiusuraForzata = True
      Exit Function
   End If
      
      
   'Imposto a FALSE "F" il parametro AZIONE nel file di configurazione
   'Call WriteINI("AZIONE", "RELOAD_TAB", "F", IniLocalPath)
   Call GetDatiTabPrimo
   
   
   GetValoriPRIMO = True
   
   
GestErr:
   If Err.Number <> 0 Then
      'gChiusuraForzata = True
      Dim vDesErr As String
      vDesErr = Err.Number & " - " & Err.Description
      
      Call MsgInLogFile("ERRORE!!! -> Funzione GetValoriPRIMO -> " & vDesErr, True)
      
      Call Form1.ShowAPP(True, vDesErr & vbNewLine & vbNewLine & _
                               "(Si consiglia di contattare l'Assistenza il prima possibile!)")
   End If
   On Error GoTo 0
End Function

Private Function SetQueryDB() As Boolean
'QUESTA QUERY MI CONTROLLA LE ANOMALIE CHE SI POSSO VERIFICARE SUI PLANNING DALL'INTRODUZIONE DEL _
 MULTIPLANNING (RELEASE 2.2)
   
   Dim vVal As String
   
   Dim vCaseA_Qry1 As String '(estrae le Attivit future raggruppandole per Cliente e Data Attivit prendendo in considerazione quella con data/ora minore nel caso ce ne siano 2 o pi)
   Dim vCaseA_Qry2 As String '(estrae le Attivit in JOIN con la query A1 considerando solo i Clienti con numero di cellulare popolato e con flag 'promemoria' attivo [ANSMSPRO = 'S']. Il campo StartDateTime viene diviso in 'data' e 'ora' e formattato per avere compatibilit con la tabella STARTSMS_PROMEM)
   Dim vCaseA_Qry3 As String '(estrae dalla tabella STARTSMS_PROMEM tutti gli SMS processati futuri in Stato 'Inviato' [SP_STATO = 1])
   Dim vCaseA_Qry4 As String '(estrazione DEFINITIVA: tutte le Attivit presenti in questa Query sono anomalie da sistemare processando per ognuna il relativo SMS PROMEMORIA)
   
   Dim vCaseB_Qry1 As String '(estrae tutte le Attivit future. Pi che altro questa query server per estrarre il campo StartDateTime diviso in 'data' e 'ora' e formattato in modo da avere compatibilit con la tabella STARTSMS_PROMEM)
   Dim vCaseB_Qry2 As String '(estrazione DEFINITIVA: questa query verifica che gli SMS della 'B1' abbiano la corrispondente attivit eseguendo la ricerca nella A3 mettendo in relazione i campi 'Codice Cliente', 'data attiv.' E 'ora attiv.'. Pertanto tutti gli SMS presenti in questa Query sono da eliminare)
   
   Dim vCaseC_Qry1 As String '(Query 'Ricerca Duplicati' generata da Access sulla query A3! La query  raggruppata sul Cliente e sul Giorno. Estraendoli in ordine di 'Ora Attivit' vanno cancellati tutti gli SMS escluso il primo)
   
   '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
   Dim vCaseD_Qry1 As String '(estrae i Documenti di Vendita (il cui tipo  configurato per l'invio posticipato del SMS di Promo) _
                             'emessi in data uguale o maggiore alla data di sistema raggruppandole per Cliente e Data emissione prendendo _
                             'in considerazione quella con data/ora minore nel caso ce ne siano 2 o pi)
   Dim vCaseD_Qry2 As String '(estrae i documenti in JOIN con i Clienti con numero di cellulare popolato e con flag 'Comunicazione' attivo [ANSMSCNZ = 'S'].
   Dim vCaseD_Qry3 As String '(estrae dalla tabella STARTSMS_PROMEM tutti gli SMS processati futuri in Stato 'Inviato' [SP_STATO = 1]
                             'e che siano legati a documenti di vendita [SPSERDOC>0])
   Dim vCaseD_Qry4 As String '(estrazione DEFINITIVA: tutte i Documenti presenti in questa Query sono anomalie da sistemare processando per ognuna il relativo SMS COMUNICAZIONE)
   '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
   
   
   
'NOMI QUERY
   'CASO 'A': ATTIVITA' FUTURE SENZA UN SMS PROCESSATO
      vCaseA_Qry1 = "nsQry_SMS_A1_MINDATA"
      vCaseA_Qry2 = "nsQry_SMS_A2_ATTDAPROC"
      vCaseA_Qry3 = "nsQry_SMS_A3_SMSINVIATI"
      vCaseA_Qry4 = "nsQry_SMS_A4_SMSCTRLPROM"
   
   'CASO 'B': SMS PROCESSATI SENZA ALCUNA ATTIVITA' INDIVIDUATA
      vCaseB_Qry1 = "nsQry_SMS_B1_ATTFUT"
      vCaseB_Qry2 = "nsQry_SMS_B2_SMSCTRLATT"
   
   'CASO 'C': SMS PROCESSATI DOPPI PER LO STESSO CLIENTE, NELLO STESSO GIORNO
      vCaseC_Qry1 = "nsQry_SMS_C1_SMSDUPL"
   
   
   '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
   'CASO 'D': DOCUMENTI VENDITA EMESSI A CUI INVIARE SMS PROMO (indicato nella causale del documento)
      vCaseD_Qry1 = "nsQry_SMS_D1_DOC"
      vCaseD_Qry2 = "nsQry_SMS_D2_DINV"
      vCaseD_Qry3 = "nsQry_SMS_D3_SMSINVIATI"
      vCaseD_Qry4 = "nsQry_SMS_D4_SMSCTRLDOC"
   '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
      
      
   On Error GoTo GestErr
   
      
'QUI VERIFICO SE ELIMINARE LE QUERY  //////////////////////////////////////////////////////////////////////////////////////////////////////
      vVal = ReadINI("AZIONE", "QUERY_DEL", IniLocalPath)
         If vVal = "T" Then
            ConnDBPrimo.Execute "DROP VIEW " & vCaseA_Qry1
            ConnDBPrimo.Execute "DROP VIEW " & vCaseA_Qry2
            ConnDBPrimo.Execute "DROP VIEW " & vCaseA_Qry3
            ConnDBPrimo.Execute "DROP VIEW " & vCaseA_Qry4
            
            ConnDBPrimo.Execute "DROP VIEW " & vCaseB_Qry1
            ConnDBPrimo.Execute "DROP VIEW " & vCaseB_Qry2
            
            ConnDBPrimo.Execute "DROP VIEW " & vCaseC_Qry1
            
            
            '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
            ConnDBPrimo.Execute "DROP VIEW " & vCaseD_Qry1
            ConnDBPrimo.Execute "DROP VIEW " & vCaseD_Qry2
            ConnDBPrimo.Execute "DROP VIEW " & vCaseD_Qry3
            ConnDBPrimo.Execute "DROP VIEW " & vCaseD_Qry4
            '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
            
         End If
         Call WriteINI("AZIONE", "QUERY_DEL", "F", IniLocalPath) 'La spengo sempre in modo che sia valida solo una volta
   
   
'QUI CREO LE FRASI ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'ACCESS ************************************************************************************************************************************************
      If gTipoDB = 0 Then
      
         'CASO 'A': ATTIVITA' FUTURE SENZA UN SMS PROCESSATO - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
            vCaseA_Qry1 = "CREATE VIEW " & vCaseA_Qry1 & " AS " & _
                        "SELECT STARTCAL_EVENTI.COD_CONTO, Min(STARTCAL_EVENTI.STARTDATETIME) AS MinData " & _
                        "  FROM STARTCAL_EVENTI " & _
                        " GROUP BY STARTCAL_EVENTI.COD_CONTO, DateValue([StartDateTime]) " & _
                        "HAVING (((STARTCAL_EVENTI.COD_CONTO)<>'') AND ((DateValue([StartDateTime]))>Date())) "
            
            vCaseA_Qry2 = "CREATE VIEW " & vCaseA_Qry2 & " AS " & _
                        "SELECT DISTINCT EV1.COD_CONTO, DateValue([StartDateTime]) AS JustDate, TimeValue([StartDateTime]) AS JustTime, Int(Format(JustTime,'hhnn')) AS NumericTime, EV1.StartDateTime, STARTCONTI.ANNUMCEL, STARTCONTI.ANSMSPRO, EV1.Created AS DtaCreazione, EV1.Modified AS DtaModifica, EV1.EventID, STARTCONTI.ANDESCR2 " & _
                        "  FROM (STARTCAL_EVENTI AS EV1 RIGHT JOIN nsQry_SMS_A1_MINDATA ON (EV1.StartDateTime = nsQry_SMS_A1_MINDATA.MinData) AND (EV1.COD_CONTO = nsQry_SMS_A1_MINDATA.COD_CONTO)) LEFT JOIN STARTCONTI ON EV1.COD_CONTO = STARTCONTI.ANCODICE " & _
                        " WHERE ( (STARTCONTI.ANNUMCEL <> '') " & _
                        "   AND (STARTCONTI.ANSMSPRO = 'S') AND (STARTCONTI.ANTIPCON = 'C') " & _
                        "   AND (DateValue(StartDateTime) > (DateValue([EV1].[Created]) + 1)) ) " & _
                        "   AND ([StartDateTime]>([EV1].[Modified]+1)) "
            
            vCaseA_Qry3 = "CREATE VIEW " & vCaseA_Qry3 & " AS " & _
                        "SELECT STARTSMS_PROMEM.SPCODCLI, STARTSMS_PROMEM.SPDATATT, STARTSMS_PROMEM.SPORAATT, STARTSMS_PROMEM.SPDATPRO, STARTSMS_PROMEM.SPORAPRO, STARTSMS_PROMEM.SP_IDSMS, STARTSMS_PROMEM.SP_STATO, STARTSMS_PROMEM.SP_ERROR, STARTSMS_PROMEM.SPMESSAG, STARTSMS_PROMEM.SPDATINV, STARTSMS_PROMEM.SPORAINV, STARTSMS_PROMEM.SPDATDEL, STARTSMS_PROMEM.SPORADEL, STARTSMS_PROMEM.SP____ID " & _
                        "  FROM STARTSMS_PROMEM " & _
                        " WHERE ((STARTSMS_PROMEM.SPDATATT > Date()) And ((STARTSMS_PROMEM.SP_STATO = 1) OR (STARTSMS_PROMEM.SP_STATO = 11)) ) "
            
'            vCaseA_Qry4 = "CREATE VIEW " & vCaseA_Qry4 & " AS " & _
'                        "SELECT nsQry_SMS_A2_ATTDAPROC.COD_CONTO, nsQry_SMS_A2_ATTDAPROC.JustDate, nsQry_SMS_A2_ATTDAPROC.NumericTime, nsQry_SMS_A2_ATTDAPROC.ANNUMCEL, nsQry_SMS_A2_ATTDAPROC.ANSMSPRO, nsQry_SMS_A2_ATTDAPROC.StartDateTime, nsQry_SMS_A2_ATTDAPROC.DtaCreazione, nsQry_SMS_A2_ATTDAPROC.DtaModifica, nsQry_SMS_A2_ATTDAPROC.EventID, nsQry_SMS_A2_ATTDAPROC.ANDESCR2 " & _
'                        "  FROM nsQry_SMS_A2_ATTDAPROC " & _
'                        " WHERE Not Exists " & _
'                        "       (SELECT nsQry_SMS_A3_SMSINVIATI.SPCODCLI, nsQry_SMS_A3_SMSINVIATI.SPDATPRO, nsQry_SMS_A3_SMSINVIATI.SPORAPRO, nsQry_SMS_A3_SMSINVIATI.SP_IDSMS, nsQry_SMS_A3_SMSINVIATI.SP_STATO, " & _
'                        "        nsQry_SMS_A3_SMSINVIATI.SP_ERROR , nsQry_SMS_A3_SMSINVIATI.SPMESSAG " & _
'                        "        From nsQry_SMS_A3_SMSINVIATI " & _
'                        "        Where (nsQry_SMS_A3_SMSINVIATI.SPCODCLI = nsQry_SMS_A2_ATTDAPROC.COD_CONTO) And (nsQry_SMS_A3_SMSINVIATI.SPDATATT = nsQry_SMS_A2_ATTDAPROC.JustDate) And (nsQry_SMS_A3_SMSINVIATI.SPORAATT = nsQry_SMS_A2_ATTDAPROC.NumericTime)) "
            vCaseA_Qry4 = "CREATE VIEW " & vCaseA_Qry4 & " AS " & _
                        "SELECT nsQry_SMS_A2_ATTDAPROC.COD_CONTO, nsQry_SMS_A2_ATTDAPROC.JustDate, nsQry_SMS_A2_ATTDAPROC.NumericTime, nsQry_SMS_A2_ATTDAPROC.ANNUMCEL, nsQry_SMS_A2_ATTDAPROC.ANSMSPRO, nsQry_SMS_A2_ATTDAPROC.StartDateTime, nsQry_SMS_A2_ATTDAPROC.DtaCreazione, nsQry_SMS_A2_ATTDAPROC.DtaModifica, nsQry_SMS_A2_ATTDAPROC.EventID, nsQry_SMS_A2_ATTDAPROC.ANDESCR2 " & _
                        "  FROM nsQry_SMS_A3_SMSINVIATI RIGHT JOIN nsQry_SMS_A2_ATTDAPROC ON (nsQry_SMS_A3_SMSINVIATI.SPORAATT = nsQry_SMS_A2_ATTDAPROC.NumericTime) AND (nsQry_SMS_A3_SMSINVIATI.SPDATATT = nsQry_SMS_A2_ATTDAPROC.JustDate) AND (nsQry_SMS_A3_SMSINVIATI.SPCODCLI = nsQry_SMS_A2_ATTDAPROC.COD_CONTO) " & _
                        " WHERE (nsQry_SMS_A3_SMSINVIATI.SPCODCLI Is Null) "
         
         
         'CASO 'B': SMS PROCESSATI SENZA ALCUNA ATTIVITA' INDIVIDUATA - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
            vCaseB_Qry1 = "CREATE VIEW " & vCaseB_Qry1 & " AS " & _
                        "SELECT STARTCAL_EVENTI.COD_CONTO, DateValue([StartDateTime]) AS JustDate, TimeValue([StartDateTime]) AS JustTime, Int(Format(JustTime,'hhnn')) AS NumericTime, STARTCAL_EVENTI.StartDateTime " & _
                        "  FROM STARTCAL_EVENTI " & _
                        " WHERE (STARTCAL_EVENTI.COD_CONTO<>'') AND (DateValue([StartDateTime])>Date()) "
            
'            vCaseB_Qry2 = "CREATE VIEW " & vCaseB_Qry2 & " AS " & _
'                        "SELECT nsQry_SMS_A3_SMSINVIATI.SPDATATT, nsQry_SMS_A3_SMSINVIATI.SPORAATT, nsQry_SMS_A3_SMSINVIATI.SPCODCLI, nsQry_SMS_A3_SMSINVIATI.SPDATPRO, nsQry_SMS_A3_SMSINVIATI.SPORAPRO, nsQry_SMS_A3_SMSINVIATI.SP_IDSMS, nsQry_SMS_A3_SMSINVIATI.SP_STATO, nsQry_SMS_A3_SMSINVIATI.SP_ERROR, nsQry_SMS_A3_SMSINVIATI.SPMESSAG, nsQry_SMS_A3_SMSINVIATI.SP____ID " & _
'                        "  FROM nsQry_SMS_A3_SMSINVIATI " & _
'                        " WHERE Not Exists " & _
'                        "       (SELECT COD_CONTO , JustDate, NumericTime " & _
'                        "        From nsQry_SMS_B1_ATTFUT " & _
'                        "        Where (nsQry_SMS_B1_ATTFUT.COD_CONTO = nsQry_SMS_A3_SMSINVIATI.SPCODCLI) " & _
'                        "          AND (nsQry_SMS_B1_ATTFUT.JustDate = nsQry_SMS_A3_SMSINVIATI.SPDATATT) " & _
'                        "          AND (nsQry_SMS_B1_ATTFUT.NumericTime = nsQry_SMS_A3_SMSINVIATI.SPORAATT)) "
            vCaseB_Qry2 = "CREATE VIEW " & vCaseB_Qry2 & " AS " & _
                        "SELECT nsQry_SMS_A3_SMSINVIATI.SPDATATT, nsQry_SMS_A3_SMSINVIATI.SPORAATT, nsQry_SMS_A3_SMSINVIATI.SPCODCLI, nsQry_SMS_A3_SMSINVIATI.SPDATPRO, nsQry_SMS_A3_SMSINVIATI.SPORAPRO, nsQry_SMS_A3_SMSINVIATI.SP_IDSMS, nsQry_SMS_A3_SMSINVIATI.SP_STATO, nsQry_SMS_A3_SMSINVIATI.SP_ERROR, nsQry_SMS_A3_SMSINVIATI.SPMESSAG, nsQry_SMS_A3_SMSINVIATI.SP____ID " & _
                        "  FROM nsQry_SMS_A3_SMSINVIATI LEFT JOIN nsQry_SMS_B1_ATTFUT ON (nsQry_SMS_A3_SMSINVIATI.SPCODCLI = nsQry_SMS_B1_ATTFUT.COD_CONTO) AND (nsQry_SMS_A3_SMSINVIATI.SPDATATT = nsQry_SMS_B1_ATTFUT.JustDate) AND (nsQry_SMS_A3_SMSINVIATI.SPORAATT = nsQry_SMS_B1_ATTFUT.NumericTime) " & _
                        " WHERE (nsQry_SMS_B1_ATTFUT.COD_CONTO Is Null) "
                        
                        
         'CASO 'C': SMS PROCESSATI DOPPI PER LO STESSO CLIENTE, NELLO STESSO GIORNO
            vCaseC_Qry1 = "CREATE VIEW " & vCaseC_Qry1 & " AS " & _
               "SELECT nsQry_SMS_A3_SMSINVIATI.SPCODCLI, nsQry_SMS_A3_SMSINVIATI.SPDATATT, nsQry_SMS_A3_SMSINVIATI.SPORAATT, nsQry_SMS_A3_SMSINVIATI.SPDATPRO, nsQry_SMS_A3_SMSINVIATI.SPORAPRO, nsQry_SMS_A3_SMSINVIATI.SP_IDSMS, nsQry_SMS_A3_SMSINVIATI.SP_STATO, nsQry_SMS_A3_SMSINVIATI.SP_ERROR, nsQry_SMS_A3_SMSINVIATI.SPMESSAG, nsQry_SMS_A3_SMSINVIATI.SPDATINV, nsQry_SMS_A3_SMSINVIATI.SPORAINV, nsQry_SMS_A3_SMSINVIATI.SPDATDEL, nsQry_SMS_A3_SMSINVIATI.SPORADEL, nsQry_SMS_A3_SMSINVIATI.SP____ID " & _
               "  FROM nsQry_SMS_A3_SMSINVIATI " & _
               " WHERE (((nsQry_SMS_A3_SMSINVIATI.SPCODCLI) In (SELECT [SPCODCLI] FROM [nsQry_SMS_A3_SMSINVIATI] As Tmp GROUP BY [SPCODCLI],[SPDATATT] HAVING Count(*)>1  And [SPDATATT] = [nsQry_SMS_A3_SMSINVIATI].[SPDATATT]))) "
               
            
            
            
         '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
         'CASO 'D': DOCUMENTI VENDITA EMESSI A CUI INVIARE SMS PROMO (indicato nella causale del documento) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
            vCaseD_Qry1 = "CREATE VIEW " & vCaseD_Qry1 & " AS " & _
                        "SELECT MIN(STARTDOC_MAST.MVSERIAL) AS SERDOC, (STARTDOC_MAST.MVCODCON) AS CODCON, (STARTDOC_MAST.MVDATTRA) AS DATADOC, " & _
                        "Min(STARTDOC_MAST.MVORADOC) AS JustTime, Min(Int(Format(MVORADOC,'hhnn'))) AS NumericTime, MIN(STARTTIP_DOC.TDTXTSMS) AS TextMSG " & _
                        "FROM STARTTIP_DOC INNER JOIN STARTDOC_MAST ON (STARTTIP_DOC.TDFLVEAC = STARTDOC_MAST.MVFLVEAC) AND (STARTTIP_DOC.TDTIPDOC = STARTDOC_MAST.MVTIPDOC) " & _
                        "GROUP BY STARTDOC_MAST.MVCODCON, STARTDOC_MAST.MVDATTRA, DateValue([STARTDOC_MAST].[MVDATTRA]), STARTTIP_DOC.TDFLSMSD, " & _
                        "STARTDOC_MAST.MVTIPCON " & _
                        "HAVING (((STARTDOC_MAST.MVCODCON)<>'') AND ((DateValue([STARTDOC_MAST].[MVDATTRA]))>=Date()) " & _
                        "AND ((STARTTIP_DOC.TDFLSMSD)=1) AND ((STARTDOC_MAST.MVTIPCON)='C'))"


            
            vCaseD_Qry2 = "CREATE VIEW " & vCaseD_Qry2 & " AS " & _
                        "SELECT nsQry_SMS_D1_DOC.SERDOC, nsQry_SMS_D1_DOC.CODCON, nsQry_SMS_D1_DOC.DATADOC, nsQry_SMS_D1_DOC.JustTime, " & _
                        "nsQry_SMS_D1_DOC.NumericTime, (nsQry_SMS_D1_DOC.DATADOC & ' ' & nsQry_SMS_D1_DOC.JustTime) AS DataOraDoc, nsQry_SMS_D1_DOC.TextMSG, " & _
                        "STARTCONTI.ANDESCR2, STARTCONTI.ANTIPCON, STARTCONTI.ANNUMCEL, STARTCONTI.ANSMSPRO, STARTCONTI.ANSMSCOM, " & _
                        "STARTCONTI.ANSMSCNZ " & _
                        "FROM STARTCONTI INNER JOIN nsQry_SMS_D1_DOC ON STARTCONTI.ANCODICE = nsQry_SMS_D1_DOC.CODCON " & _
                        "WHERE (STARTCONTI.ANTIPCON='C') AND (STARTCONTI.ANNUMCEL<>'') AND (STARTCONTI.ANSMSCNZ='S')"


            
            vCaseD_Qry3 = "CREATE VIEW " & vCaseD_Qry3 & " AS " & _
                        "SELECT STARTSMS_PROMEM.SPCODCLI, STARTSMS_PROMEM.SPDATATT, STARTSMS_PROMEM.SPORAATT, STARTSMS_PROMEM.SPDATPRO, " & _
                        "STARTSMS_PROMEM.SPORAPRO, STARTSMS_PROMEM.SP_IDSMS, STARTSMS_PROMEM.SP_STATO, STARTSMS_PROMEM.SP_ERROR, " & _
                        "STARTSMS_PROMEM.SPMESSAG, STARTSMS_PROMEM.SPDATINV, STARTSMS_PROMEM.SPORAINV, STARTSMS_PROMEM.SPDATDEL, " & _
                        "STARTSMS_PROMEM.SPORADEL, STARTSMS_PROMEM.SP____ID " & _
                        "From STARTSMS_PROMEM " & _
                        "WHERE (STARTSMS_PROMEM.SPDATATT>Date()) AND (STARTSMS_PROMEM.SP_STATO=1 Or STARTSMS_PROMEM.SP_STATO=11) " & _
                        "AND (STARTSMS_PROMEM.SPSERDOC>0)"


            vCaseD_Qry4 = "CREATE VIEW " & vCaseD_Qry4 & " AS " & _
                        "SELECT nsQry_SMS_D2_DINV.SERDOC, nsQry_SMS_D2_DINV.CODCON, nsQry_SMS_D2_DINV.DATADOC, nsQry_SMS_D2_DINV.JustTime, " & _
                        "nsQry_SMS_D2_DINV.NumericTime, nsQry_SMS_D2_DINV.DataOraDoc, nsQry_SMS_D2_DINV.TextMSG, " & _
                        "nsQry_SMS_D2_DINV.ANDESCR2, nsQry_SMS_D2_DINV.ANTIPCON, nsQry_SMS_D2_DINV.ANNUMCEL, nsQry_SMS_D2_DINV.ANSMSPRO, " & _
                        "nsQry_SMS_D2_DINV.ANSMSCOM, nsQry_SMS_D2_DINV.ANSMSCNZ " & _
                        "FROM nsQry_SMS_D3_SMSINVIATI RIGHT JOIN nsQry_SMS_D2_DINV ON (nsQry_SMS_D3_SMSINVIATI.SPCODCLI = nsQry_SMS_D2_DINV.CODCON) " & _
                        "AND (nsQry_SMS_D3_SMSINVIATI.SPDATATT = nsQry_SMS_D2_DINV.DATADOC) AND (nsQry_SMS_D3_SMSINVIATI.SPORAATT = nsQry_SMS_D2_DINV.NumericTime) " & _
                        "WHERE nsQry_SMS_D3_SMSINVIATI.SPCODCLI Is Null"

               
'SQL ************************************************************************************************************************************************
      Else
      
         'CASO 'A': ATTIVITA' FUTURE SENZA UN SMS PROCESSATO - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
            vCaseA_Qry1 = "CREATE VIEW " & vCaseA_Qry1 & " AS " & _
                        "SELECT        COD_CONTO, MIN(StartDateTime) AS MinData " & _
                        "  FROM dbo.STARTCAL_EVENTI " & _
                        " GROUP BY COD_CONTO, CONVERT(CHAR(10), StartDateTime, 103) " & _
                        " HAVING        (COD_CONTO <> '') AND (CONVERT(CHAR(10), StartDateTime, 103) > GETDATE()) "
            
            vCaseA_Qry2 = "CREATE VIEW " & vCaseA_Qry2 & " AS " & _
                        "SELECT DISTINCT " & _
                        " EV1.COD_CONTO, CONVERT(VARCHAR(10), EV1.StartDateTime, 103) AS JustDate, FORMAT(EV1.StartDateTime, 'HHmm') AS JustTime, CAST(FORMAT(EV1.StartDateTime, 'HHmm') AS Int) AS NumericTime, " & _
                        " EV1.StartDateTime, dbo.STARTCONTI.ANNUMCEL, dbo.STARTCONTI.ANSMSPRO, EV1.Created AS DtaCreazione, EV1.Modified AS DtaModifica, EV1.EventID, STARTCONTI.ANDESCR2 " & _
                        "  FROM dbo.STARTCAL_EVENTI AS EV1 RIGHT OUTER JOIN " & _
                        "       dbo.nsQry_SMS_A1_MINDATA ON EV1.StartDateTime = dbo.nsQry_SMS_A1_MINDATA.MinData AND EV1.COD_CONTO = dbo.nsQry_SMS_A1_MINDATA.COD_CONTO LEFT OUTER JOIN " & _
                        "       dbo.STARTCONTI ON EV1.COD_CONTO = dbo.STARTCONTI.ANCODICE " & _
                        " WHERE (dbo.STARTCONTI.ANNUMCEL <> '') " & _
                        "   AND (dbo.STARTCONTI.ANSMSPRO = 'S') AND (dbo.STARTCONTI.ANTIPCON = 'C') " & _
                        "   AND (CONVERT(Date, EV1.StartDateTime) > CONVERT(Date, (EV1.Created + 1)) ) " & _
                        "   AND (EV1.StartDateTime > (EV1.Modified + 1) )"

            vCaseA_Qry3 = "CREATE VIEW " & vCaseA_Qry3 & " AS " & _
                        "SELECT TOP (100) PERCENT SPCODCLI, SPDATATT, SPORAATT, SPDATPRO, SPORAPRO, SP_IDSMS, SP_STATO, SP_ERROR, SPMESSAG, SPDATINV, SPORAINV, SPDATDEL, SPORADEL, SP____ID " & _
                        "  From dbo.STARTSMS_PROMEM " & _
                        " Where (SPDATATT > GETDATE()) And ((SP_STATO = 1) OR (SP_STATO = 11)) "
            
            vCaseA_Qry4 = "CREATE VIEW " & vCaseA_Qry4 & " AS " & _
                        "SELECT COD_CONTO, JustDate, NumericTime, ANNUMCEL, ANSMSPRO, StartDateTime, DtaCreazione, DtaModifica, EventID, ANDESCR2 " & _
                        "  FROM nsQry_SMS_A3_SMSINVIATI RIGHT JOIN nsQry_SMS_A2_ATTDAPROC ON (nsQry_SMS_A3_SMSINVIATI.SPORAATT = nsQry_SMS_A2_ATTDAPROC.NumericTime) AND (nsQry_SMS_A3_SMSINVIATI.SPDATATT = nsQry_SMS_A2_ATTDAPROC.JustDate) AND (nsQry_SMS_A3_SMSINVIATI.SPCODCLI = nsQry_SMS_A2_ATTDAPROC.COD_CONTO) " & _
                        " WHERE (nsQry_SMS_A3_SMSINVIATI.SPCODCLI Is Null) "
                        
         
         'CASO 'B': SMS PROCESSATI SENZA ALCUNA ATTIVITA' INDIVIDUATA - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
            vCaseB_Qry1 = "CREATE VIEW " & vCaseB_Qry1 & " AS " & _
                        "SELECT COD_CONTO, CONVERT(VARCHAR(10), StartDateTime, 103) AS JustDate, FORMAT(StartDateTime, 'HHmm') AS JustTime, CAST(FORMAT(StartDateTime, 'HHmm') AS Int) AS NumericTime, StartDateTime " & _
                        "  FROM dbo.STARTCAL_EVENTI " & _
                        " WHERE (COD_CONTO <> '') AND (CONVERT(VARCHAR(10), StartDateTime, 103) > GETDATE()) "
            
'            vCaseB_Qry2 = "CREATE VIEW " & vCaseB_Qry2 & " AS " & _
'                        "SELECT SPDATATT, SPORAATT, SPCODCLI, SPDATPRO, SPORAPRO, SP_IDSMS, SP_STATO, SP_ERROR, SPMESSAG, SP____ID " & _
'                        "  From dbo.nsQry_SMS_A3_SMSINVIATI " & _
'                        " WHERE (NOT EXISTS " & _
'                        "            (SELECT COD_CONTO, JustDate, NumericTime " & _
'                        "               FROM dbo.nsQry_SMS_B1_ATTFUT " & _
'                        "              WHERE (COD_CONTO = dbo.nsQry_SMS_A3_SMSINVIATI.SPCODCLI) AND (JustDate = dbo.nsQry_SMS_A3_SMSINVIATI.SPDATATT) AND (NumericTime = dbo.nsQry_SMS_A3_SMSINVIATI.SPORAATT))) "
            vCaseB_Qry2 = "CREATE VIEW " & vCaseB_Qry2 & " AS " & _
                        "SELECT SPDATATT, SPORAATT, SPCODCLI, SPDATPRO, SPORAPRO, SP_IDSMS, SP_STATO, SP_ERROR, SPMESSAG, SP____ID " & _
                        "  FROM nsQry_SMS_A3_SMSINVIATI LEFT JOIN nsQry_SMS_B1_ATTFUT ON (nsQry_SMS_A3_SMSINVIATI.SPCODCLI = nsQry_SMS_B1_ATTFUT.COD_CONTO) AND (nsQry_SMS_A3_SMSINVIATI.SPDATATT = nsQry_SMS_B1_ATTFUT.JustDate) AND (nsQry_SMS_A3_SMSINVIATI.SPORAATT = nsQry_SMS_B1_ATTFUT.NumericTime) " & _
                        " WHERE (nsQry_SMS_B1_ATTFUT.COD_CONTO Is Null) "
                        
         'CASO 'C': SMS PROCESSATI DOPPI PER LO STESSO CLIENTE, NELLO STESSO GIORNO
            vCaseC_Qry1 = "CREATE VIEW " & vCaseC_Qry1 & " AS " & _
                        "SELECT SPCODCLI, SPDATATT, SPORAATT, SPDATPRO, SPORAPRO, SP_IDSMS, SP_STATO, SP_ERROR, SPMESSAG, SPDATINV, SPORAINV, SPDATDEL, SPORADEL, SP____ID " & _
                        "  FROM dbo.nsQry_SMS_A3_SMSINVIATI " & _
                        " WHERE (SPCODCLI IN  " & _
                        "            (SELECT SPCODCLI " & _
                        "               FROM dbo.nsQry_SMS_A3_SMSINVIATI AS Tmp " & _
                        "              GROUP BY SPCODCLI, SPDATATT " & _
                        "             HAVING (COUNT(*) > 1) AND (SPDATATT = dbo.nsQry_SMS_A3_SMSINVIATI.SPDATATT))) "
                        
                        
                        
                        
                        
         '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
         'CASO 'D': DOCUMENTI VENDITA EMESSI A CUI INVIARE SMS PROMO (indicato nella causale del documento) - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
         vCaseD_Qry1 = "CREATE VIEW " & vCaseA_Qry1 & " AS " & _
                        "SELECT MIN(dbo.STARTDOC_MAST.MVSERIAL) AS SERDOC, dbo.STARTDOC_MAST.MVCODCON AS CODCON, dbo.STARTDOC_MAST.MVDATTRA AS DATADOC, " & _
                        "MIN(dbo.STARTDOC_MAST.MVORADOC) AS JustTime, MIN(REPLACE(CONVERT(varchar(5), dbo.STARTDOC_MAST.MVORADOC, 108), '.', '')) AS NumericTime " & _
                        "FROM dbo.STARTTIP_DOC INNER JOIN dbo.STARTDOC_MAST ON dbo.STARTTIP_DOC.TDTIPDOC = dbo.STARTDOC_MAST.MVTIPDOC " & _
                        "AND dbo.STARTTIP_DOC.TDFLVEAC = dbo.STARTDOC_MAST.MVFLVEAC " & _
                        "GROUP BY dbo.STARTDOC_MAST.MVCODCON, dbo.STARTDOC_MAST.MVDATTRA, dbo.STARTDOC_MAST.MVDATTRA, dbo.STARTTIP_DOC.TDFLSMSD, " & _
                        "dbo.STARTDOC_MAST.MVTIPCON " & _
                        "HAVING (dbo.STARTDOC_MAST.MVCODCON <> '') AND (dbo.STARTDOC_MAST.MVDATTRA >= CONVERT(varchar(10), GETDATE(), 103)) " & _
                        "AND (dbo.STARTTIP_DOC.TDFLSMSD = 1) AND (dbo.STARTDOC_MAST.MVTIPCON = 'C')"


            
            vCaseD_Qry2 = "CREATE VIEW " & vCaseA_Qry2 & " AS " & _
                        "SELECT dbo.nsQry_SMS_D1_DOC.SERDOC, dbo.nsQry_SMS_D1_DOC.CODCON, dbo.nsQry_SMS_D1_DOC.DATADOC, dbo.nsQry_SMS_D1_DOC.JustTime, " & _
                        "dbo.nsQry_SMS_D1_DOC.NumericTime, CAST(dbo.nsQry_SMS_D1_DOC.DATADOC AS varchar(12)) + ' ' + CAST(dbo.nsQry_SMS_D1_DOC.JustTime AS varchar(8)) AS DataOraDoc, " & _
                        "dbo.nsQry_SMS_D1_DOC.TextMSG, dbo.STARTCONTI.ANDESCR2, dbo.STARTCONTI.ANTIPCON, " & _
                        "dbo.STARTCONTI.ANNUMCEL, dbo.STARTCONTI.ANSMSPRO, dbo.STARTCONTI.ANSMSCOM, dbo.STARTCONTI.ANSMSCNZ " & _
                        "FROM dbo.STARTCONTI INNER JOIN dbo.nsQry_SMS_D1_DOC ON dbo.STARTCONTI.ANCODICE = dbo.nsQry_SMS_D1_DOC.CODCON " & _
                        "WHERE (dbo.STARTCONTI.ANTIPCON = 'C') AND (dbo.STARTCONTI.ANNUMCEL <> '') AND (dbo.STARTCONTI.ANSMSCNZ = 'S') "


            vCaseD_Qry3 = "CREATE VIEW " & vCaseA_Qry3 & " AS " & _
                        "SELECT SPCODCLI, SPDATATT, SPORAATT, SPDATPRO, SPORAPRO, SP_IDSMS, SP_STATO, SP_ERROR, SPMESSAG, SPDATINV, " & _
                        "SPORAINV, SPDATDEL, SPORADEL, SP____ID " & _
                        "FROM dbo.STARTSMS_PROMEM " & _
                        "WHERE (SPDATATT > GETDATE()) AND (SP_STATO = 1 OR SP_STATO = 11) AND (SPSERDOC > 0)"
            
            
            vCaseD_Qry4 = "CREATE VIEW " & vCaseA_Qry4 & " AS " & _
                       "SELECT dbo.nsQry_SMS_D2_DINV.SERDOC, dbo.nsQry_SMS_D2_DINV.CODCON, dbo.nsQry_SMS_D2_DINV.DATADOC, " & _
                       "dbo.nsQry_SMS_D2_DINV.JustTime, dbo.nsQry_SMS_D2_DINV.NumericTime, dbo.nsQry_SMS_D2_DINV.DataOraDoc, " & _
                       "dbo.nsQry_SMS_D2_DINV.TextMSG, dbo.nsQry_SMS_D2_DINV.ANDESCR2, dbo.nsQry_SMS_D2_DINV.ANTIPCON, " & _
                       "dbo.nsQry_SMS_D2_DINV.ANNUMCEL , dbo.nsQry_SMS_D2_DINV.ANSMSPRO, dbo.nsQry_SMS_D2_DINV.ANSMSCOM, dbo.nsQry_SMS_D2_DINV.ANSMSCNZ " & _
                       "FROM dbo.nsQry_SMS_D3_SMSINVIATI RIGHT OUTER JOIN dbo.nsQry_SMS_D2_DINV ON dbo.nsQry_SMS_D3_SMSINVIATI.SPORAATT = dbo.nsQry_SMS_D2_DINV.NumericTime " & _
                       "AND dbo.nsQry_SMS_D3_SMSINVIATI.SPDATATT = dbo.nsQry_SMS_D2_DINV.DATADOC AND " & _
                       "dbo.nsQry_SMS_D3_SMSINVIATI.SPCODCLI = dbo.nsQry_SMS_D2_DINV.CODCON " & _
                       "WHERE (dbo.nsQry_SMS_D3_SMSINVIATI.SPCODCLI Is Null) "
                        
      End If
      
      
      
'CREO LE QUERY /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      ConnDBPrimo.Execute vCaseA_Qry1
      ConnDBPrimo.Execute vCaseA_Qry2
      ConnDBPrimo.Execute vCaseA_Qry3
      ConnDBPrimo.Execute vCaseA_Qry4
      
      ConnDBPrimo.Execute vCaseB_Qry1
      ConnDBPrimo.Execute vCaseB_Qry2
      
      ConnDBPrimo.Execute vCaseC_Qry1
      
      
      '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
      ConnDBPrimo.Execute vCaseD_Qry1
      ConnDBPrimo.Execute vCaseD_Qry2
      ConnDBPrimo.Execute vCaseD_Qry3
      ConnDBPrimo.Execute vCaseD_Qry4
      '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
      
      SetQueryDB = True
   
   
GestErr:
   If Err.Number = -2147217865 Then
      Resume Next 'In caso di Rimozione e non  presente
   ElseIf Err.Number = -2147217900 Then
      Resume Next 'In caso si tenta di Creare ed  gi presente
   ElseIf Err.Number <> 0 Then
   
      Dim vDesErr As String
      vDesErr = Err.Number & " - " & Err.Description
   
      Call MsgInLogFile("ERRORE!!! -> Sub 'SetQueryDB' -> " & vDesErr, True)
      
      Call Form1.ShowAPP(True, vDesErr & vbNewLine & vbNewLine & _
                               "(Si consiglia di contattare l'Assistenza il prima possibile!)")
   End If
   On Error GoTo 0
End Function

Private Function GetParamSMS() As Boolean
      Dim RS As ADODB.Recordset
      Dim strRicerca As String
      
      On Error GoTo GestErr
      
   
      strRicerca = "SELECT * " & _
                   "  FROM [ANA_AZIENDE] " & _
                   " WHERE (AZCODAZI = '" & gAzienda & "') "
      Set RS = New ADODB.Recordset
      RS.Open strRicerca, ConnDBPrimo, adOpenStatic
      If RS.EOF = False Then
         
         'USER x TRENDOO
            If Len(Trim(NonNullo(RS!AZSMSUSR))) > 0 Then
               gSmsUSER = Trim(RS!AZSMSUSR)
            Else
               'gChiusuraForzata = True
               Call MsgInLogFile("AVVISO!!! -> UTENTE SMS non impostato nei DatiAzienda di PRIMO", True)
               Call Form1.ShowAPP(True, "UTENTE SMS non impostato nei DatiAzienda di PRIMO" & vbNewLine & vbNewLine & _
                                        "(Si consiglia di contattare l'Assistenza il prima possibile!)")
               GoTo SaltaPerErr
            End If
         
         'PASSWORD x TRENDOO
            If Len(Trim(NonNullo(RS!AZSMSPSW))) > 0 Then
               gSmsPSSW = Trim(RS!AZSMSPSW)
            Else
               'gChiusuraForzata = True
               Call MsgInLogFile("AVVISO!!! -> PASSWORD SMS non impostata nei DatiAzienda di PRIMO", True)
               Call Form1.ShowAPP(True, "PASSWORD SMS non impostata nei DatiAzienda di PRIMO" & vbNewLine & vbNewLine & _
                                        "(Si consiglia di contattare l'Assistenza il prima possibile!)")
               GoTo SaltaPerErr
            End If
         
         'MITTENTE x TRENDOO
            If Len(Trim(NonNullo(RS!AZSMSMIT))) > 0 Then
               gSmsMITT = Trim(RS!AZSMSMIT)
            Else
               'gChiusuraForzata = True
               Call MsgInLogFile("AVVISO!!! -> MITTENTE SMS non impostato nei DatiAzienda di PRIMO", True)
               Call Form1.ShowAPP(True, "MITTENTE SMS non impostato nei DatiAzienda di PRIMO" & vbNewLine & vbNewLine & _
                                        "(Si consiglia di contattare l'Assistenza il prima possibile!)")
               GoTo SaltaPerErr
            End If
         
         
         'Codifico i parametri per l'URL
            gSmsUSER = CodificaStringaURL(gSmsUSER)
            gSmsPSSW = CodificaStringaURL(gSmsPSSW)
            gSmsMITT = CodificaStringaURL(gSmsMITT)
         
         
         'Variabili per gli SMS (sopratutto Promemoria)
            'gSmsAbilitati = NonNullo(RS!AZSMSABILIT, True)
            gSmsTxtPromem = Trim(NonNullo(RS!AZSMSTXTPRO))
            gSmsOrePreavv = NonNullo(RS!AZSMSOREPRE, True): If gSmsOrePreavv = 0 Then gSmsOrePreavv = 24 'se mancano le imposto di default a 24
            gSmsPrefInter = NonNullo(RS!AZPREFISINT)
            gSmsLenAlias = NonNullo(RS!AZSMSLENALIAS, True)
            
                           
                           
            '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
            gSmsPostVendita = NonNullo(RS!AZSMSPOSVEN, True)
            gSmsOrePosticipate = NonNullo(RS!AZSMSOREPOS, True): If gSmsOrePosticipate = 0 Then gSmsOrePosticipate = 24 'se mancano le imposto di default a 24
            gSmsOreMaxPostVendita = NonNullo(RS!AZSMSMAXOREPOS, True): If gSmsOreMaxPostVendita = 0 Then gSmsOreMaxPostVendita = 24 'se mancano le imposto di default a 24
            '***** 07.11.2018 CLAUDIA-SMS CONFIGURAZIONE INVIO A CHIUSURA DEI DOCUMENTI DI CASSA DEL GIORNO
            
                           
      Else
         'gChiusuraForzata = True
         Call MsgInLogFile("AVVISO!!! -> Problemi nell'individuazione dell'Indirizzo Web nei DatiAzienda di PRIMO", True)
         Call Form1.ShowAPP(True, "Problemi nell'individuazione dell'Indirizzo Web nei DatiAzienda di PRIMO" & vbNewLine & vbNewLine & _
                                  "(Si consiglia di contattare l'Assistenza il prima possibile!)")
         GoTo SaltaPerErr
      End If
      
      GetParamSMS = True
      
SaltaPerErr:
      RS.Close
      Set RS = Nothing
            

      'CHE CI SIA IL TESTO DEL PROMEMORIA ALTRIMENTI CHIUDO
      If Len(gSmsTxtPromem) = 0 Then
         GetParamSMS = False
         Call MsgInLogFile("AVVISO!!! -> Nessun 'Testo Promemoria' impostato in PRIMO")
         'Call Form1.CHIUDI(True)
         Call WriteINI("AZIONE", "CLOSE", "T", IniLocalPath)
      End If
      
      
      
GestErr:
   If Err.Number <> 0 Then
   
      Dim vDesErr As String
      vDesErr = Err.Number & " - " & Err.Description
      
      'gChiusuraForzata = True
      Call MsgInLogFile("ERRORE!!! -> Caricam. Indirizzo Web da PRIMO -> " & vDesErr, True)
      
      Call Form1.ShowAPP(True, vDesErr & vbNewLine & vbNewLine & _
                               "(Si consiglia di contattare l'Assistenza il prima possibile!)")
             
   End If
   On Error GoTo 0

End Function


Public Sub GetDatiTabPrimo()
   
   'Inizializzo la Griglia
      Form1.GrigliaDB(0).ClearContent
      Form1.GrigliaDB(0).Columns.DeleteAll
      
      
                                    'Form1.GrigliaDB(0).Visible = True
                                    'Form1.GrigliaDB(0).ZOrder


'   If pNewRicerca = False Then
   'QUI POPOLO LE TABELLE (REPORTCONTROL) CON I CLIENTI
      Call ReportInsCol(Form1.GrigliaDB(0), "CODICE", "S050T", False, 0, False, False, 0)
      Call ReportInsCol(Form1.GrigliaDB(0), "DESCRIZIONE", "S100T", False, 0, False, False, 1)
                        'GrigliaDB(0).Visible = True
                        'GrigliaDB(0).ZOrder
'
'      Load GrigliaDB(1)
'      Call ReportInsCol(GrigliaDB(1), "CODICE", "S050T", False, 0, False, False, 0)
'      Call ReportInsCol(GrigliaDB(1), "DESCRIZIONE", "S100T", False, 0, False, False, 1)
'                        'GrigliaDB(1).Left = GrigliaDB(0).Left + GrigliaDB(0).Width + 60
'                        'GrigliaDB(1).ZOrder
'                        'GrigliaDB(1).Visible = True
'
'   Else
'      'Suoto le Griglie
'      GrigliaDB(0).ClearContent
'      GrigliaDB(1).ClearContent
'
'   End If
   
   
   'QUI POPOLO LE GRIGLIE
      Dim RS As ADODB.Recordset
      Dim strRicerca As String
      Dim I As Integer
      Dim vTabella As String


      If I = 0 Then
         vTabella = "CLIENTE"
         strRicerca = "SELECT ANCODICE AS dbCODICE,ANDESCRI AS dbDESCRI " & _
                      "  FROM [" & gAzienda & "CONTI] " & _
                      " WHERE (ANTIPCON = 'C') " & _
                      " ORDER BY ANCODICE"
                      '"   AND NOT ((ANCODAPP = '') OR (ISNULL(ANCODAPP))) " &
'         Else
'            vTabella = "SERVIZIO/ARTICOLO"
'            strRicerca = "SELECT ARCODICE AS dbCODICE,ARDESCRI AS dbDESCRI " & _
'                         "  FROM [" & Azienda & "ART_ICOL] " & _
'                         " WHERE (ARFL_WEB = 'SI') " & _
'                         " ORDER BY ARCODICE"
      End If

      Set RS = New ADODB.Recordset
      RS.Open strRicerca, ConnDBPrimo, adOpenStatic
      If RS.EOF = False Then
         With Form1.GrigliaDB(I)
            Do Until RS.EOF
               Call ReportInsRow(Form1.GrigliaDB(I), String(.Columns.Count, ""))    'INSERISCO LA STRINGA

               .Records(.Records.Count - 1).Item(0).Value = RS!dbCODICE
               .Records(.Records.Count - 1).Item(1).Value = RS!dbDESCRI

               RS.MoveNext
            Loop

            'Call MsgInLogFile("   > Acquisito elenco " & IIf(i = 0, "CLIENTI", "SERVIZI/ARTICOLI"))
            .Populate
         End With
      'Else
         'gChiusuraForzata = True
         'Call MsgInLogFile("AVVISO!!! -> Nessun 'Cliente' presente in Anagrafica di PRIMO", True)
         'Call Form1.ShowAPP(True, "Nessun 'Cliente' presente in Anagrafica di PRIMO" & vbNewLine & vbNewLine & _
                                  "(Si consiglia di contattare l'Assistenza il prima possibile!)")
         'Exit Sub
      End If
      RS.Close
      Set RS = Nothing

      
GestErr:
   If Err.Number <> 0 Then
   
      Dim vDesErr As String
      vDesErr = Err.Number & " - " & Err.Description
      
      'gChiusuraForzata = True
      Call MsgInLogFile("ERRORE!!! -> Caricam. valori da Tabelle DB -> " & vDesErr, True)
      
      Call Form1.ShowAPP(True, "Caricamento valori da Tabelle DB" & vbNewLine & vbNewLine & vDesErr & vbNewLine & vbNewLine & _
                               "(Si consiglia di contattare l'Assistenza il prima possibile!)")
   End If
   On Error GoTo 0

End Sub



Private Function ApriConnessioneACCESS(pPathDB As String) As Boolean
   'If gConnPRIMOOpened Then ApriConnessioneACCESS = True: Exit Function
   
   On Error GoTo GestErr

   'Qui mi collego al Database
   Set ConnDBPrimo = New ADODB.Connection
   
   ConnDBPrimo.ConnectionString = "Provider = Microsoft.Jet.OLEDB.4.0;Data Source =" & pPathDB & ";Jet OLEDB:Database Password='primols';"
   ConnDBPrimo.CommandTimeout = gMaxTimeout 'Tempo di Timeout impostato a 2 minuti (di default  15 secondi)
   ConnDBPrimo.Open
   ConnDBPrimo.CursorLocation = adUseClient
   
   'Call MsgInLogFile("   > Aperta Connessione DB PRIMO")
   
   gConnPRIMOOpened = True
   ApriConnessioneACCESS = True

GestErr:
   If Err.Number <> 0 Then
   
      Dim vDesErr As String
      vDesErr = Err.Number & " - " & Err.Description
   
      Call MsgInLogFile("ERRORE!!! -> Connessione al DB PRIMO -> " & vDesErr, True)
      
      Call Form1.ShowAPP(True, "Connessione al DB PRIMO" & vbNewLine & vDesErr & vbNewLine & vbNewLine & _
                               "(Si consiglia di contattare l'Assistenza il prima possibile!)")
             
   End If
   On Error GoTo 0
End Function

Public Function ApriConnessioneSQL(pNomeServerSQL As String, pNomeDBSQL_GEN As String, pPassword_SA As String, pConnessioneTrusted As String) As Boolean
   On Error GoTo GestErr
   
   Set ConnDBPrimo = New ADODB.Connection
   If pConnessioneTrusted = "1" Then
      'ConnDBPrimo.ConnectionString = "Provider=SQLOLEDB.1;Password=" & Password_SA & ";Persist Security Info=False;User ID=sa;Initial Catalog=" & NomeDBSQL_GEN & ";Data Source=" & NomeServerSQL
      ConnDBPrimo.ConnectionString = "Provider=SQLOLEDB;Data Source=" & pNomeServerSQL & ";Initial Catalog=" & pNomeDBSQL_GEN & ";Integrated Security=SSPI"
   Else
      ConnDBPrimo.ConnectionString = "Provider=SQLOLEDB.1;Password=" & pPassword_SA & ";Persist Security Info=False;User ID=sa;Initial Catalog=" & pNomeDBSQL_GEN & ";Data Source=" & pNomeServerSQL
   End If
   ConnDBPrimo.CommandTimeout = gMaxTimeout 'Tempo di Timeout impostato nel file di configurazione (di default  15 secondi)
   ConnDBPrimo.Open


   gConnPRIMOOpened = True
   ApriConnessioneSQL = True

GestErr:
   If Err.Number <> 0 Then
   
      Dim vDesErr As String
      vDesErr = Err.Number & " - " & Err.Description
   
      Call MsgInLogFile("ERRORE!!! -> Connessione al DB 'SQL' -> " & vDesErr, True)
      
      Call Form1.ShowAPP(True, "Connessione al DB 'SQL'" & vbNewLine & vDesErr & vbNewLine & vbNewLine & _
                               "(Si consiglia di contattare l'Assistenza il prima possibile!)")
   End If
   On Error GoTo 0
End Function


Public Sub ChiudiConnessioneDBPrimo()
   If gConnPRIMOOpened = False Then Exit Sub
   
   On Error Resume Next
   ConnDBPrimo.Close
   gConnPRIMOOpened = False
   'Call MsgInLogFile("   > Chiusa Connessione DB PRIMO")
   'Call MsgInLogFile("    ---^---^---^---^---^---^---^---^---^---^---/^\---^---^---^---^---^---^---^---^---^---^---^---")
End Sub


Public Sub VerificaEsistenzaPathCartella(pPathCartella As String, Optional pSoloControllo As Boolean, Optional prEsistenza As Boolean)
   'Questa sub serve per controllare l'esistenza di una cartella e se non esiste la crea _
    salvo che il parametro pSoloControllo non si a TRUE. In questo caso effettua SOLO il controllo. _
    L'esito dell'esistenza  passato al parametro di ritorno prEsistenza (questo l'ho fatto perch _
    non ho voluto trasformare la Sub in Funzione perch gi usata all'interno del programma)
   
   Dim MyFolder As String
   
   'restituisce una stringa vuota se la cartella non esiste
   MyFolder = Dir(pPathCartella, vbDirectory)
   If Len(Trim(MyFolder)) = 0 Then
   'crea la cartella
      If pSoloControllo = False Then MkDir pPathCartella
      prEsistenza = False
   Else
      prEsistenza = True
   End If

End Sub


Public Function VerificaEsistenzaFile(pPathFile As String) As Boolean
   Dim MyFile As String
            
   'restituisce una stringa vuota se la cartella non esiste
   MyFile = Dir(pPathFile, vbNormal)
   If Len(Trim(MyFile)) = 0 Then
      'Il file non esiste
      VerificaEsistenzaFile = False
   Else
      'Il file esiste
      VerificaEsistenzaFile = True
   End If

End Function



Public Function CodificaStringaURL(pStr As String) As String
   'questa funzione restituisce la stringa codificata per l'URL
   Dim I As Integer
   Dim vStrConv As String
   
   vStrConv = ""
   
   For I = 1 To Len(pStr)
   
      vStrConv = vStrConv & CodificaCharURL(Mid(pStr, I, 1))
      
   Next I
   
   CodificaStringaURL = vStrConv

End Function
Private Function CodificaCharURL(pChar As String) As String
   'questa funziona codifica il carattare nella simbologia adatta all'URL
   Dim vValChar As Integer
   
   vValChar = Asc(pChar)
   
   Select Case vValChar
   Case 48 To 57 'Numeri
      CodificaCharURL = pChar
      Exit Function
   
   Case 65 To 90 'Lettere MAIUSCOLE
      CodificaCharURL = pChar
      Exit Function
    
   Case 97 To 122 'lettere minuscole
      CodificaCharURL = pChar
      Exit Function
      
'Qui inizio con le codifiche
   Case 32  '  spazio
      CodificaCharURL = "%20"
      Exit Function
   
'Lettere accentate
   Case 224  '  
      CodificaCharURL = "%C3%A0"
      Exit Function
   Case 232  '  
      CodificaCharURL = "%C3%A8"
      Exit Function
   Case 233  '  
      CodificaCharURL = "%C3%A9"
      Exit Function
   Case 236  '  
      CodificaCharURL = "%C3%AC"
      Exit Function
   Case 242  '  
      CodificaCharURL = "%C3%B2"
      Exit Function
   Case 249  '  
      CodificaCharURL = "%C3%B9"
      Exit Function
   
'PIU' USATI
   Case 34  '  "
      CodificaCharURL = "%22"
      Exit Function
   Case 39  '  '
      CodificaCharURL = "%27"
      Exit Function
   Case 43  '  +
      CodificaCharURL = "%2B"
      Exit Function
   Case 44  '  ,
      CodificaCharURL = "%2C"
      Exit Function
   Case 45  '  -
      CodificaCharURL = "%2D"
      Exit Function
   Case 46  '  .
      CodificaCharURL = "%2E"
      Exit Function
   Case 47  '  /
      CodificaCharURL = "%2F"
      Exit Function
   Case 58  '  :
      CodificaCharURL = "%3A"
      Exit Function
   Case 59  '  ;
      CodificaCharURL = "%3B"
      Exit Function
   Case 63  '  ?
      CodificaCharURL = "%3F"
      Exit Function
   Case 64  '  @
      CodificaCharURL = "%40"
      Exit Function
   Case 37  '  %
      CodificaCharURL = "%25"
      Exit Function
   Case 38  '  &
      CodificaCharURL = "%26"
      Exit Function
   Case 40  '  (
      CodificaCharURL = "%28"
      Exit Function
   Case 41  '  )
      CodificaCharURL = "%29"
      Exit Function
   Case 42  '  *
      CodificaCharURL = "%2A"
      Exit Function
   Case 128  '  
      CodificaCharURL = "%E2%82%AC"
      Exit Function
   Case 95  ' _ '
      CodificaCharURL = "%5F"
      Exit Function

'MENO USATI
   Case 60  '  <
      CodificaCharURL = "%3C"
      Exit Function
   Case 61  '  =
      CodificaCharURL = "%3D"
      Exit Function
   Case 62  '  >
      CodificaCharURL = "%3E"
      Exit Function
   Case 91  '  [
      CodificaCharURL = "%5B"
      Exit Function
   Case 92  '  \
      CodificaCharURL = "%5C"
      Exit Function
   Case 93  '  ]
      CodificaCharURL = "%5D"
      Exit Function
   Case 94  '  ^
      CodificaCharURL = "%5E"
      Exit Function
   Case 123  '  {
      CodificaCharURL = "%7B"
      Exit Function
   Case 124  '  |
      CodificaCharURL = "%7C"
      Exit Function
   Case 125  '  }
      CodificaCharURL = "%7D"
      Exit Function
   Case 126  '  ~
      CodificaCharURL = "%7E"
      Exit Function
   Case 35  '  #
      CodificaCharURL = "%23"
      Exit Function
   
   Case Else
      CodificaCharURL = pChar
   End Select
' Eccco la lista dei caratteri che necessitano di una codifica particolare :
' Carattere Codifica URL
' Tabulazione %09
' Spazio %20
' " %22
' # %23
' % %25
' & %26
' ( %28
' ) %29
' + %2B
' , %2C
' . %2E
' / %2F
' : %3A
' ; %3B
' < %3C
' = %3D
' > %3E
' ? %3F
' @ %40
' [ %5B
' \ %5C
' ] %5D
' ^ %5E
' ' %60
' { %7B
' | %7C
' } %7D
' ~ %7E

End Function


Public Sub SetAlwaysOnTopMode(hWndOrForm As Variant, Optional ByVal OnTop As Boolean = True)
   Dim hWnd As Long
   ' get the hWnd of the form to be move on top
   If VarType(hWndOrForm) = vbLong Then
      hWnd = hWndOrForm
   Else
      hWnd = hWndOrForm.hWnd
   End If
   SetWindowPos hWnd, IIf(OnTop, HWND_TOPMOST, HWND_NOTOPMOST), 0, 0, 0, 0, _
   SWP_NOMOVE Or SWP_NOSIZE Or SWP_SHOWWINDOW
End Sub


Public Function ImpostaNumCelConPrefInternaz(pNumCel As String, pPrefIntern As String) As String
   'Controllo che ci sia il prefisso internazionale all'inizio
   If Mid(pNumCel, 1, 1) = "+" Then
      ImpostaNumCelConPrefInternaz = pNumCel
   ElseIf Mid(pNumCel, 1, 2) = "00" Then  'Nel caso si sia registrato sul cliente il prefisso "0039" anzich "+39"
      ImpostaNumCelConPrefInternaz = pNumCel
   Else 'Se non c'e' lo inserisco
      ImpostaNumCelConPrefInternaz = pPrefIntern & pNumCel
   End If
End Function

Public Sub MoveFormByDragDrop(MouseButton As Integer, objForm As Form)
   If MouseButton = vbLeftButton Then
       ReleaseCapture
       SendMessage objForm.hWnd, WM_NCLBUTTONDOWN, HTCAPTION, 0&
   End If
End Sub

Public Sub OpenWebPage(pForm As Form, pIndirizzo As String, Optional pSkype As Boolean)
   Dim success As Integer
   
   If Len(Trim(pIndirizzo)) > 0 Then
      
      If pSkype = False Then
         If Trim(pIndirizzo) = "http://www." Or Trim(pIndirizzo) = "" Then ' I have the pIndirizzo set to http://www.
             'MsgBox "Inserire un indirizzo web", vbCritical, "Mancanza di Dati"
             Exit Sub
         ElseIf Left(Trim(pIndirizzo), 11) = "http://www." Then
             Site = Trim(pIndirizzo)
         ElseIf Left(Trim(pIndirizzo), 4) = "www." Then
             Site = "http://" & Trim(pIndirizzo)
         Else
             Site = "http://www." & Trim(pIndirizzo)
         End If
         success% = ShellToBrowser(pForm, Site, SW_SHOWNORMAL)
      Else
         success% = ShellToBrowser(pForm, "skype:" & pIndirizzo & "?chat", SW_SHOWNORMAL)
      End If
      
   End If
End Sub

Function ShellToBrowser%(Frm As Form, ByVal URL$, ByVal WindowStyle%)
'FUNZIONE PER APRIRE IL SITO INTERNET CLICCANDO SU UN LINK
   Dim api%
   
   api% = ShellExecute(Frm.hWnd, "open", URL$, "", App.Path, WindowStyle%)
   'Intercetta il valore restituito
   If api% < 31 Then
   'codice dell'errore - guarda l'help delle api per maggiori informazioni
       MsgBox App.Title & " ha un problema nel far avviare il Web Browser. Controllare che sia installato correttamente.(Error" & Format$(api%) & ")", 48, "Browser Non Disponibile"
       ShellToBrowser% = False
   ElseIf api% = 32 Then
   'nessun file associato
       MsgBox App.Title & " non riesce a trovare un file associato a " & URL$ & " sul sistema. Controllare che il browser sia installato correttamente e associato con questo tipo di file.", 48, "Browser Non Disponibile"
       ShellToBrowser% = False
   Else
       'E' al lavoro!
       ShellToBrowser% = True
   End If
End Function



